<?php
// Router

class Router {
    public static function dispatch() {
        $url = isset($_GET['url']) ? $_GET['url'] : 'login';
        $url = explode('/', rtrim($url, '/'));

        $controllerName = ucfirst(array_shift($url));
        $actionName = isset($url[0]) ? $url[0] : 'index';
        $params = array_slice($url, 1);

        $controllerFile = 'controllers/' . $controllerName . '.php';
        if (file_exists($controllerFile)) {
            require_once $controllerFile;
            if (class_exists($controllerName)) {
                $controller = new $controllerName();
                if (method_exists($controller, $actionName)) {
                    call_user_func_array(array($controller, $actionName), $params);
                } else {
                    die('Action not found!');
                }
            } else {
                die('Controller class not found!');
            }
        } else {
            die('Controller file not found!');
        }
    }
}
?>